# 鱼皮的 AI 指南 - 3、AI 编程技巧

> ⭐️ 推荐观看视频版：[https://www.bilibili.com/video/BV1i9Z8YhEja](https://www.bilibili.com/video/BV1i9Z8YhEja/)



其实现在很多程序员朋友对 AI 还是持怀疑态度的，觉得 AI 是不是只能做点儿小网站、小项目。我之前也是这么想的，直到我纯用 AI、完全不写代码地做了一个有几万行代码的大项目，我才发现 AI 的进化，远比我的想象更可怕。

当然，想用 AI 做大项目，还是有很多技巧的。为啥使用相同的 AI 工具，有同学能做出来网站，有同学只能做出来一堆 Bug 呢？这一部分，我们就来解决一个问题 —— **如何让 AI 生成的代码更准确？**

### **1、优化 Prompt**

Prompt 的质量直接决定了 AI 生成代码的准确性，也正因如此，才有了 Prompt 工程的概念、市面上才出现了提示词工程师这个岗位。

首先我们要掌握最基本的 Prompt 优化技巧，比如明确 AI 的角色、提供具体的细节要求、拆解任务、提供示例等等，这里 [智谱 AI 开放平台的文档](https://open.bigmodel.cn/dev/guidelines/LanguageModels) 总结得不错，大家可以学习下。

![](https://pic.yupi.icu/1/1743563253132-91a453b7-b090-4258-89de-aa98da404a30.png)

此外，我更建议先把自己手写的 Prompt 扔给其他 AI，让它帮我生成一段质量更高的、结构化的需求文档，再喂给 Cursor 去生成网站，效果会更好。

完整的需求文档通常包括：

- 明确项目背景和目标
- 详细列出功能要求和技术栈
- 指定代码风格和架构模式
- 提供示例和参考资料
- 明确限制条件和边界场景



### **2、复杂项目的生成技巧**

对于复杂的项目，想一步到位是不现实的，可以采用分步迭代的策略：

1. 先利用 Cursor 的 Agent 模式 + 高级推理模型生成基础项目框架，暂时不管功能好不好用，确保能够运行项目即可
2. 划分模块和功能点，依次向 AI 提问，逐步实现核心功能并验证是否可用。
3. 在保证不影响功能的前提下，优化实现细节。

听起来很简单，但实际操作时，大家经常会遇到 AI 输出的内容驴头不对马嘴、生成了一个新功能后原来的功能就不能用了、改了一个 Bug 又来 3 个 Bug 的情况。怎么办呢？

教你几招：

1）项目模块化。由于 AI 的脑容量不大，能接受的上下文是有限的，随着你的项目信息量不断增大，它有可能忘记之前的信息，导致生成的代码错误。所以我们要把项目的功能尽可能隔离开，把一个大项目分割成多个小项目，让 AI 生成某个功能时只需要关注一小部分上下文，得到的结果会更精准。

举个例子，开发一个电商系统，可以把商品管理模块独立出来，当需要 AI 生成添加商品功能的代码时，只需要提供像商品表的字段设计、添加商品的业务逻辑规则，不需要把支付结算、用户会员等关联不大的功能作为上下文提供给 AI。

2）限定修改范围。AI 生成的代码没有那么可控，经常改 A 功能的同时把 B 功能也顺带修改了。这个问题很好解决，只要在提示词中限定修改范围即可，比如：

```markdown
仅修改 services/order.java 中的 CreateOrder 方法：
1. 添加分布式锁防止超卖  
2. 保持现有日志格式  
3. 不要改动其他文件
```

3）抽象和复用。假如我们要让 AI 生成 2 个布局一模一样的页面，它有的时候会很死板，生成完页面 A 之后，复制一遍页面 A 的代码来生成页面 B。这样非常不利于大项目的生成和维护，以后 AI 改了页面 A，说不定页面 B 就忘了改，跟人来开发一样。所以我们需要留个心眼儿，适当地告诉 AI：请帮我抽象 XX 页面、XX 代码为可复用的组件。这样也能减少整个项目的代码量，也有助于减轻 AI 上下文记忆的负担，让生成结果更准确。

4）版本控制。建议利用 Git 版本控制工具对代码进行管理，每正确生成一个功能后都提交一次版本，在每次 AI 生成新代码之后人工对比一下改动的文件，出了问题也能快速还原到之前的版本，防止代码丢失。

![](https://pic.yupi.icu/1/1743563352611-61418c68-7c48-4bdd-8d97-941f40b9f98d.png)

### **3、其他技巧**

掌握了上面这些，是完全可以利用 AI 生成复杂大项目的。还有一些其他小技巧，大家自己看一看就好：

1. 注意操作系统：AI 更喜欢 Linux 或 Mac 系统的终端，执行命令的能力更强。如果使用 Windows 系统，可以通过安装 Linux 子系统（WSL）来替代自带的终端。或者在和 AI 对话的上下文中明确告诉它使用 Windows 系统的终端命令，否则可能 AI 给的很多命令都是无法运行的。
2. 人工控制：AI 有时会因缺乏关键上下文信息、或者自身能力的不足而陷入循环，这时就有必要人工介入了。可以尝试手动指定上下文、更换 Prompt 来引导 AI。
3. 多元 AI 协作：不同 AI 大模型擅长不同任务，如果单一大模型无法正常完成工作，可以利用其他大模型生成 “教 AI 做事的方法和指令”，增加解决问题的可能性。

------

OK，AI 使用技巧还是挺多的，建议大家可以多去练习练习，看到这里，你应该就超过了 90% 的同学。

